/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#include "re_thread.h"
#include "gpioclass.h"

#include <QFile>
#include <QTimer>
#include <iostream>
#include <math.h>
#include <QMessageBox>
#include <QDebug>

QT_USE_NAMESPACE

RotaryEncoderThread::RotaryEncoderThread(QObject *parent): QObject(parent)
{
	GPIO_Preparation();

    Relay_GPIO->setval_gpio("1");

	RE_timer = new QTimer(this);
	QObject::connect(RE_timer, SIGNAL(timeout()), this, SLOT(readRE()));

	RE_timer2 = new QTimer(this);
	QObject::connect(RE_timer2, SIGNAL(timeout()), this, SLOT(readMode()));
	//RE_timer2->start(500);	//check whether manual or transparent mode is enabled every 0.5 seconds

    Accel_Timer = new QTimer(this);
    QObject::connect(Accel_Timer, SIGNAL(timeout()), this, SLOT(acceleration()));
}

RotaryEncoderThread::~RotaryEncoderThread()
{
	RE_timer->stop();
	RE_timer2->stop();
	delete RE_timer;
	delete RE_timer2;
//    Enter_GPIO->unexport_gpio();
//    A_GPIO->unexport_gpio();
//    B_GPIO->unexport_gpio();
//    Mode_GPIO->unexport_gpio();
	delete Enter_GPIO;
	delete A_GPIO;
	delete B_GPIO;
	delete Mode_GPIO;
    delete Relay_GPIO;
}

void RotaryEncoderThread::GPIO_Preparation(){

    Mode_GPIO = new GPIOClass("25");
	Enter_GPIO = new GPIOClass("19");
	A_GPIO = new GPIOClass("13");
	B_GPIO = new GPIOClass("26");
    Relay_GPIO = new GPIOClass("5");
	usleep(1000000);    //wait a sec
	Mode_GPIO->setdir_gpio("in");
	Enter_GPIO->setdir_gpio("in");
	A_GPIO->setdir_gpio("in");
	B_GPIO->setdir_gpio("in");
    Relay_GPIO->setdir_gpio("out");
}

void RotaryEncoderThread::process()
{
	RE_timer2->start(500);	//poll the GPIO's every milisecond (maybe overkill? idk...)
}

void RotaryEncoderThread::stop_process(){
    emit finished();
}

/**
 * @brief RotaryEncoderThread::readRE
 * read the rotary encoder GPIOs
 */
void RotaryEncoderThread::readRE(){
	Enter_GPIO->getval_gpio(enterval);
	A_GPIO->getval_gpio(Aval);
	B_GPIO->getval_gpio(Bval);

	//std::cout << Aval << " " << Bval << "\n";

    if(enterval == "0"){
        emit knob_enter();
        usleep(250000); //500ms?
    }
    if(oldA == "1" && oldB == "1" && Aval == "0" && Bval == "1"){
        emit knob_right();
        accelcounter++;
    }
    else if(oldA == "1" && oldB == "1" && Aval == "1" && Bval == "0"){
       emit knob_left();
        accelcounter--;
    }

	oldA = Aval;
	oldB = Bval;
}

/**
 * @brief RotaryEncoderThread::readmode
 * Check whether the program needs to run in manual or transparent mode
 */
void RotaryEncoderThread::readMode(){
	Mode_GPIO->getval_gpio(modeval);
	if(modeval != oldMode){
        if(modeval == "1"){	//manual mode
			emit manual_mode();
            RE_timer->start(5);
            Accel_Timer->start(125);
            qDebug() << "knob timer started";
		}
        else if(modeval == "0"){
			emit transparent_mode();
			RE_timer->stop();
            Accel_Timer->stop();
            qDebug() << "knob timer stopped";
		}
	}
	oldMode = modeval;
}

void RotaryEncoderThread::acceleration(){
    if(accelcounter > 3 || accelcounter < -3){
        emit accelerate();
    }
    else{
        emit decelerate();
    }
    accelcounter = 0;
}
